IF OBJECT_ID('F_FORMATAR_TEXTO') IS NOT NULL 
	DROP FUNCTION F_FORMATAR_TEXTO 
GO 
/*
=======================================================================================
'Nvel Classificao.: INFORMAO RESTRITA
'Verso..............: 21081601
'Job.................:  
'Nome................: F_FORMATAR_TEXTO 
'Objetivo............: Funo responsavel por substituir caracteres especiais  
'Tabelas.............: 
'Dt Criao..........: 16/09/2021
'Dt Ult Alteraco....: 
'Alterado por........: 
'Criado por..........: Marcos barros
'=======================================================================================

*/

CREATE FUNCTION F_FORMATAR_TEXTO (
	@TEXTO VARCHAR(MAX)
)
RETURNS VARCHAR(MAX)
AS
BEGIN

	DECLARE @TEXTO_FORMATADO VARCHAR(MAX)

	-- O trecho abaixo possibilita que caracteres como "" ou "", sejam convertidos para "o" ou "a", respectivamente
	SET @TEXTO_FORMATADO = UPPER(@TEXTO)
	    COLLATE sql_latin1_general_cp1250_ci_as

	-- O trecho abaixo remove acentos e outros caracteres especiais, substituindo os mesmos por letras normais
	SET @TEXTO_FORMATADO = @TEXTO_FORMATADO
	    COLLATE sql_latin1_general_cp1251_ci_as

	RETURN @TEXTO_FORMATADO

END



/*
=========================================================================
-- EXEMPLOS DE  USO
=========================================================================

-- UPDATE 
UPDATE <TABELA>  
SET
  <CAMPO_TABELA> = dbo.FN_FORMATAR_TEXTO(B.<CAMPO_TABELA>)
FROM
  <TABELA> 
INNER JOIN <TABELA> B
  ON <TABELA>.<CAMPO_TABELA> = B.<CAMPO_TABELA>
WHERE
  <TABELA>.<CAMPO_TABELA> = <CONDIO EX: ID = 1>


-- SELECT 
SELECT 
	dbo.FN_FORMATAR_TEXTO(<CAMPO_TABELA>) AS CAMPO_TABELA 
FROM 
	<TABELA>
WHERE 
	<CONDIO QUANDO EXISTIR>
*/